/*
 * Decompiled with CFR 0.152.
 */
package Network;

import GUI.FileNotification;
import Interfaces.I_Controller;
import MainRealDrop.FileReceiver;
import Network.PortManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class PortManagerThread
extends Thread {
    private Socket client = null;
    private I_Controller ctrl = null;

    public PortManagerThread(Socket client, I_Controller ctrl) {
        this.client = client;
        this.ctrl = ctrl;
    }

    @Override
    public void run() {
        try {
            byte[] bufR = new byte[2048];
            InputStream is = this.client.getInputStream();
            OutputStream os = this.client.getOutputStream();
            int lenBufR = is.read(bufR);
            String[] commands = new String(bufR, 0, lenBufR).split(",");
            System.out.println("[" + this.client.getInetAddress() + "] Say : " + commands);
            System.out.println("Parsing command from the client...");
            String fileName = "Unknow filename";
            boolean portRequest = false;
            boolean pingRequest = false;
            String[] stringArray = commands;
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                System.out.println("Command received : " + s);
                if (s.split(":")[0].equals("FILENAME")) {
                    fileName = s.split(":")[1];
                }
                if (s.split(":")[0].equals("TP") && s.split(":")[1].equals("?")) {
                    portRequest = true;
                }
                if (s.split(":")[0].equals("PING")) {
                    pingRequest = true;
                    break;
                }
                ++n2;
            }
            if (portRequest) {
                FileNotification notif = new FileNotification(fileName);
                notif.start();
                try {
                    notif.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.out.println("Thread ended");
                if (notif.getReturnValue() == 0) {
                    System.out.println("User refuse the transfer");
                } else if (notif.getReturnValue() == 1) {
                    System.out.println("User accept the file !!");
                } else {
                    System.out.println("Error with notification");
                }
                this.ctrl.askPermissions(fileName, this.client.getInetAddress().getHostAddress());
                int receptionPort = PortManager.getPortFromPool();
                String localFilePath = String.valueOf(System.getProperty("user.home")) + "/Downloads/" + fileName;
                FileReceiver fr = new FileReceiver(this.client.getInetAddress().getHostAddress(), receptionPort, localFilePath);
                os.write(new String("" + receptionPort).getBytes());
                fr.receive();
            } else {
                System.out.println("Not a port request");
            }
            is.close();
            os.close();
            this.client.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

