/*
 * Decompiled with CFR 0.152.
 */
package Network;

import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class Broadcasts {
    public static String getFirstBroadcastAddress() {
        try {
            Enumeration<NetworkInterface> list = NetworkInterface.getNetworkInterfaces();
            while (list.hasMoreElements()) {
                NetworkInterface iface = list.nextElement();
                if (iface == null || iface.isLoopback() || !iface.isUp()) continue;
                for (InterfaceAddress address : iface.getInterfaceAddresses()) {
                    InetAddress broadcast;
                    if (address == null || (broadcast = address.getBroadcast()) == null) continue;
                    System.out.println("Found broadcast: " + broadcast);
                    return broadcast.getHostAddress();
                }
            }
        }
        catch (SocketException ex) {
            System.err.println("Error while getting network interfaces");
            ex.printStackTrace();
        }
        return "192.168.1.255";
    }
}

