/*
 * Decompiled with CFR 0.152.
 */
package MainRealDrop;

import GUI.UserInterface;
import Interfaces.I_ClientView;
import Interfaces.I_Controller;
import Interfaces.I_Model;
import MainRealDrop.ClientData;
import MainRealDrop.ClientDataModel;
import MainRealDrop.FileSender;
import Network.Broadcasts;
import Network.ClientPinger;
import Network.DiscoveryServiceEmitter;
import Network.DiscoveryServiceReceiver;
import Network.PortManager;
import java.io.File;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class Controller
implements I_Controller {
    I_Model model = new ClientDataModel();
    I_ClientView gui = new UserInterface();
    PortManager pm = null;
    private String userPseudo = "";

    public static void main(String[] args) {
        System.out.println("RealDrop v0.0.25b");
        URL url = ClassLoader.getSystemResource("/RealDrop/src/Resources/RealDrop_Icon.png");
        Controller ctrl = new Controller();
    }

    public Controller() {
        this.gui.setController(this);
        this.gui.setModel(this.model);
        this.pm = new PortManager(this);
        this.pm.start();
        String localMachineName = "ND";
        try {
            localMachineName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        DiscoveryServiceReceiver drs = new DiscoveryServiceReceiver(this);
        if (!this.userPseudo.equals("")) {
            localMachineName = String.valueOf(this.userPseudo) + " (" + localMachineName + ")";
        }
        DiscoveryServiceEmitter dse = new DiscoveryServiceEmitter(Broadcasts.getFirstBroadcastAddress(), "PORT:" + this.pm.getListenPort() + ",NAME:" + localMachineName);
        dse.start();
        drs.start();
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < Controller.this.model.getModelSize()) {
                    if (new ClientPinger(Controller.this.model.getClientAt(i).getFileManagerPort()).ping(Controller.this.model.getClientAt(i).getIp()) == 1) {
                        System.out.println("[Taks] Client " + Controller.this.model.getClientAt(i).getIp() + " is online");
                    } else {
                        System.out.println("[Task] Client " + Controller.this.model.getClientAt(i).getIp() + " is offline");
                        Controller.this.model.removeClient(i);
                        Controller.this.gui.updateView();
                    }
                    ++i;
                }
            }
        }, 5L, 10L, TimeUnit.SECONDS);
        System.out.println("Controller : All service started");
    }

    @Override
    public void sendFileTo(int id, String filePath) {
        System.out.println("Must send " + filePath + " to ID : " + id);
        File file = new File(filePath);
        ClientData clientToSend = this.model.getClientAt(id);
        if (new ClientPinger(clientToSend.getFileManagerPort()).ping(clientToSend.getIp()) != 1) {
            System.out.println("Host is offline file not sent");
            this.model.removeClient(id);
            this.gui.updateView();
            return;
        }
        System.out.println("Host is online");
        int tp = this.pm.getRemoteTransfertPort(this.model.getClientAt(id).getIp(), this.model.getClientAt(id).getFileManagerPort(), file.getName());
        if (tp < 0) {
            System.out.println("Error while sending file to client (maybe offline)");
        } else {
            System.out.println("Must send " + filePath + " to " + this.model.getClientAt(id).getIp() + ":" + tp);
            FileSender fs = new FileSender(this.model.getClientAt(id).getIp(), tp);
            fs.send(filePath);
        }
    }

    @Override
    public void setSenderName(String name) {
        System.out.println("SenderName : " + name);
        this.userPseudo = name;
    }

    @Override
    public void newClientDiscovered(ClientData data) {
        System.out.println("New client : " + data.getClientName() + ", " + data.getIp() + ", " + data.getFileManagerPort());
        if (!this.model.isPresent(data.getIp())) {
            int id = this.model.addClient(data);
            System.out.println("Client added to list with id : " + id);
            this.gui.updateView();
        }
    }

    @Override
    public void askPermissions(String fileName, String fromIpAddr) {
        System.out.println("Ask permissions to the user (" + fileName + "," + fromIpAddr + ")");
    }
}

