/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.ClientGUIRepresentation;
import Interfaces.I_ClientView;
import Interfaces.I_Controller;
import Interfaces.I_Model;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class UserInterface
extends JFrame
implements ActionListener,
I_ClientView {
    private I_Controller ctrl = null;
    private I_Model model = null;
    private JPanel mainPanel = null;
    private JPanel clientList = null;
    private JTextField userPseudo = null;

    public UserInterface() {
        this.setTitle("RealDrop");
        this.setSize(300, 300);
        this.setLocationRelativeTo(null);
        try {
            Image image = new ImageIcon("/Resources/RealDrop_Icon.png").getImage();
            this.setIconImage(image);
        }
        catch (Exception e) {
            System.out.println("Appilcation icon not found");
        }
        this.setDefaultCloseOperation(3);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setSize(new Dimension(this.getWidth(), this.getHeight()));
        this.mainPanel.setBorder(BorderFactory.createLineBorder(Color.RED));
        this.userPseudo = new JTextField();
        this.userPseudo.addActionListener(this);
        this.mainPanel.add((Component)this.userPseudo, "North");
        this.mainPanel.add((Component)this.createClientList(), "Center");
        this.setContentPane(this.mainPanel);
        this.setVisible(true);
    }

    private JPanel createClientList() {
        this.clientList = new JPanel();
        this.clientList.setLayout(new BoxLayout(this.clientList, 1));
        System.out.println(String.valueOf(this.mainPanel.getWidth()) + "," + this.mainPanel.getHeight());
        this.clientList.setPreferredSize(new Dimension(this.mainPanel.getWidth(), this.mainPanel.getHeight()));
        this.clientList.setBorder(BorderFactory.createLineBorder(Color.BLUE));
        return this.clientList;
    }

    @Override
    public void setController(I_Controller ctrl) {
        this.ctrl = ctrl;
    }

    @Override
    public void triggerSendFile(int id, String filePath) {
        if (this.ctrl == null) {
            System.out.println("Error Controller interface in GUI is NULL");
            return;
        }
        this.ctrl.sendFileTo(id, filePath);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.userPseudo) {
            System.out.println("Event : " + e.getID());
            if (this.ctrl == null) {
                System.out.println("Controller interface is NULL in action performed");
            }
            if (!e.getActionCommand().equals("")) {
                this.userPseudo.setFocusable(false);
                this.ctrl.setSenderName(e.getActionCommand());
            }
        }
    }

    @Override
    public void setModel(I_Model model) {
        this.model = model;
    }

    @Override
    public void updateView() {
        if (this.model == null) {
            System.out.println("Error model not set in the view");
            return;
        }
        System.out.println("Updating view");
        this.clientList.removeAll();
        int i = 0;
        while (i < this.model.getModelSize()) {
            System.out.println("GUI : Adding new client at " + i);
            this.clientList.add(new ClientGUIRepresentation(this.model.getClientAt(i).getClientName(), i, this));
            ++i;
        }
        this.validate();
    }
}

